﻿(function () {
    'use strict';
    // Uncomment the following line to enable first chance exceptions.
    // Debug.enableFirstChanceException(true);

    WinJS.Application.onmainwindowactivated = function (e) {
        if (e.detail.kind === Windows.ApplicationModel.Activation.ActivationKind.launch) {
            statusPanel.innerText = "Stahuji data z RSS";
            WinJS.xhr({ url: "http://www.maxiorel.cz/rss.xml" }).then(processPosts, downloadError);
            WinJS.UI.processAll();
        }
    }

    var postItems = [];

    function processPosts(request) {
        statusPanel.innerText = "";

        var items = request.responseXML.selectNodes("//item");
        if (items.length == 0) { statusPanel.innerText = "data se nepodařilo stáhnout"; }

        for (var i = 0, len = items.length; i < len; i++) {
            var item = items[i];
            var post = {
                title: item.selectNodes("title")[0].text,
                date: item.selectNodes("pubDate")[0].text,
                content: item.selectNodes("description")[0].text.replace(/(<([^>]+)>)/ig, ""),
            };

            postItems.push(post);
        }
        posts.winControl.dataSource = postItems;
    }

    function downloadError() {
        statusPanel.innerText = "data se nepodařilo stáhnout";
    }

    function selectionChanged(e) {
        content.innerHTML = "";
        var selection = posts.winControl.selection;

        if (selection.length) {
            var post = postItems[selection[0].begin];
            var contentTemplate = WinJS.UI.getControl(document.getElementById("contentTemplate"));
            contentTemplate.render(post).then(function (element) {
                content.appendChild(element);
            });
        }
    }

    WinJS.Namespace.define('rssReader', {

        selectionChanged: selectionChanged

    });

    WinJS.Application.start();
})();